/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.client;

import io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import io.prometheus.jmx.shaded.io.prometheus.client.CounterMetricFamily;
import io.prometheus.jmx.shaded.io.prometheus.client.DoubleAdder;
import io.prometheus.jmx.shaded.io.prometheus.client.SimpleCollector;
import io.prometheus.jmx.shaded.io.prometheus.client.exemplars.CounterExemplarSampler;
import io.prometheus.jmx.shaded.io.prometheus.client.exemplars.Exemplar;
import io.prometheus.jmx.shaded.io.prometheus.client.exemplars.ExemplarConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class Counter
extends SimpleCollector<Child>
implements Collector.Describable {
    private final Boolean exemplarsEnabled;
    private final CounterExemplarSampler exemplarSampler;

    Counter(Builder b) {
        super(b);
        this.exemplarsEnabled = b.exemplarsEnabled;
        this.exemplarSampler = b.exemplarSampler;
        this.initializeNoLabelsChild();
    }

    public static Builder build(String name, String help) {
        return (Builder)((Builder)new Builder().name(name)).help(help);
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    protected Child newChild() {
        return new Child(this.exemplarsEnabled, this.exemplarSampler);
    }

    public void inc() {
        this.inc(1.0);
    }

    public void incWithExemplar(String ... exemplarLabels) {
        this.incWithExemplar(1.0, exemplarLabels);
    }

    public void incWithExemplar(Map<String, String> exemplarLabels) {
        this.incWithExemplar(1.0, exemplarLabels);
    }

    public void inc(double amt) {
        ((Child)this.noLabelsChild).inc(amt);
    }

    public void incWithExemplar(double amt, String ... exemplarLabels) {
        ((Child)this.noLabelsChild).incWithExemplar(amt, exemplarLabels);
    }

    public void incWithExemplar(double amt, Map<String, String> exemplarLabels) {
        ((Child)this.noLabelsChild).incWithExemplar(amt, exemplarLabels);
    }

    public double get() {
        return ((Child)this.noLabelsChild).get();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>(this.children.size());
        for (Map.Entry c : this.children.entrySet()) {
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_total", (List<String>)this.labelNames, (List<String>)((List)c.getKey()), ((Child)c.getValue()).get(), ((Child)c.getValue()).getExemplar()));
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_created", this.labelNames, (List)c.getKey(), (double)((Child)c.getValue()).created() / 1000.0));
        }
        return this.familySamplesList(Collector.Type.COUNTER, samples);
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        return Collections.singletonList(new CounterMetricFamily(this.fullname, this.help, this.labelNames));
    }

    public static class Child {
        private final DoubleAdder value = new DoubleAdder();
        private final long created = System.currentTimeMillis();
        private final Boolean exemplarsEnabled;
        private final CounterExemplarSampler exemplarSampler;
        private final AtomicReference<Exemplar> exemplar = new AtomicReference();

        public Child(Boolean exemplarsEnabled, CounterExemplarSampler exemplarSampler) {
            this.exemplarsEnabled = exemplarsEnabled;
            this.exemplarSampler = exemplarSampler;
        }

        public void inc() {
            this.inc(1.0);
        }

        public void incWithExemplar(String ... exemplarLabels) {
            this.incWithExemplar(1.0, exemplarLabels);
        }

        public void incWithExemplar(Map<String, String> exemplarLabels) {
            this.incWithExemplar(1.0, exemplarLabels);
        }

        public void inc(double amt) {
            this.incWithExemplar(amt, (String[])null);
        }

        public void incWithExemplar(double amt, String ... exemplarLabels) {
            Exemplar exemplar;
            Exemplar exemplar2 = exemplar = exemplarLabels == null ? null : new Exemplar(amt, (Long)System.currentTimeMillis(), exemplarLabels);
            if (amt < 0.0) {
                throw new IllegalArgumentException("Amount to increment must be non-negative.");
            }
            this.value.add(amt);
            this.updateExemplar(amt, exemplar);
        }

        public void incWithExemplar(double amt, Map<String, String> exemplarLabels) {
            this.incWithExemplar(amt, Exemplar.mapToArray(exemplarLabels));
        }

        private void updateExemplar(double amt, Exemplar userProvidedExemplar) {
            Exemplar next;
            Exemplar prev;
            do {
                prev = this.exemplar.get();
                next = userProvidedExemplar == null ? this.sampleNextExemplar(amt, prev) : userProvidedExemplar;
                if (next != null && next != prev) continue;
                return;
            } while (!this.exemplar.compareAndSet(prev, next));
        }

        private Exemplar sampleNextExemplar(double amt, Exemplar prev) {
            CounterExemplarSampler exemplarSampler;
            if (Boolean.FALSE.equals(this.exemplarsEnabled)) {
                return null;
            }
            if (this.exemplarSampler != null) {
                return this.exemplarSampler.sample(amt, prev);
            }
            if ((Boolean.TRUE.equals(this.exemplarsEnabled) || ExemplarConfig.isExemplarsEnabled()) && (exemplarSampler = ExemplarConfig.getCounterExemplarSampler()) != null) {
                return exemplarSampler.sample(amt, prev);
            }
            return null;
        }

        public double get() {
            return this.value.sum();
        }

        private Exemplar getExemplar() {
            return this.exemplar.get();
        }

        public long created() {
            return this.created;
        }
    }

    public static class Builder
    extends SimpleCollector.Builder<Builder, Counter> {
        private Boolean exemplarsEnabled = null;
        private CounterExemplarSampler exemplarSampler = null;

        @Override
        public Counter create() {
            if (this.name.endsWith("_total")) {
                this.name = this.name.substring(0, this.name.length() - 6);
            }
            this.dontInitializeNoLabelsChild = true;
            return new Counter(this);
        }

        public Builder withExemplarSampler(CounterExemplarSampler exemplarSampler) {
            if (exemplarSampler == null) {
                throw new NullPointerException();
            }
            this.exemplarSampler = exemplarSampler;
            return this.withExemplars();
        }

        public Builder withExemplars() {
            this.exemplarsEnabled = Boolean.TRUE;
            return this;
        }

        public Builder withoutExemplars() {
            this.exemplarsEnabled = Boolean.FALSE;
            return this;
        }
    }
}

