package de.predic8.ticket;

import io.quarkus.runtime.*;

import javax.enterprise.context.*;
import javax.enterprise.event.*;
import javax.inject.*;
import javax.jms.*;
import java.util.concurrent.*;


@ApplicationScoped
public class BugConsumer implements Runnable {

    @Inject
    ConnectionFactory cf;

    private final ExecutorService scheduler = Executors.newSingleThreadExecutor();

    void onStart(@Observes StartupEvent ev) {
        scheduler.submit(this);
    }

    void onStop(@Observes ShutdownEvent ev) {
        scheduler.shutdown();
    }

    @Override
    public void run() {
        try (JMSContext ctx = cf.createContext(JMSContext.AUTO_ACKNOWLEDGE)) {
            JMSConsumer consumer = ctx.createConsumer(ctx.createQueue("ticket.bugs"));
            while (true) {
                Message msg = consumer.receive();
                if (msg == null) return;
                String json = msg.getBody(String.class);

            }
        } catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }
}