package de.predic8.ticket;

import org.apache.camel.builder.*;
import org.apache.camel.component.jackson.*;

import javax.enterprise.context.*;

import static org.apache.camel.builder.endpoint.StaticEndpointBuilders.*;

@SuppressWarnings("unused")
@ApplicationScoped
public class BugRoute extends RouteBuilder {

    @Override
    public void configure() {

        JacksonDataFormat json = new JacksonDataFormat(Ticket.class);

        from(jms("bug").advanced().jmsKeyFormatStrategy("keyFormat"))
                .id("bug-route")
                .unmarshal(json)
                .log("msg=\"Ticket aus Queue entnommen.\" ticket=${body.id} type=${body.type} queue=ticket.in.bug")
                .setProperty("id",simple("${body.id}"))
                .process(e -> Thread.sleep(800))
                .marshal(json)
                .convertBodyTo(String.class)
                .log("ticket=${exchangeProperty.id} file=bug-${exchangeProperty.id}")
                .log("${body}")
                .to(file("bugs").fileName("bug-${exchangeProperty.id}.json"));
    }
}