package de.predic8.ticket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFormat;
import static com.fasterxml.jackson.annotation.JsonFormat.*;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.*;

import java.util.Date;

@JsonAutoDetect(fieldVisibility = Visibility.ANY)
public class Ticket {

    String id;

    @JsonFormat(shape = Shape.STRING, pattern = "dd.MM.yyyy")
    Date date;

    String comment;

    String type;

    public String getId() {
        return id;
    }

    public Date getDate() {
        return date;
    }

    public String getComment() {
        return comment;
    }

    public String getType() {
        return type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "Ticket{" +
                "id='" + id + '\'' +
                ", date=" + date +
                ", comment='" + comment + '\'' +
                ", type='" + type + '\'' +
                '}';
    }
}
