package de.predic8.ticket.ticketgenerator;

import org.apache.camel.opentracing.starter.CamelOpenTracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;

import static java.util.concurrent.TimeUnit.SECONDS;
import static org.springframework.boot.SpringApplication.run;

@SpringBootApplication
@EnableScheduling
@CamelOpenTracing
public class FTPPoller {

    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static final AtomicBoolean working = new AtomicBoolean(false);

    public static void main(String[] args) {
        run(FTPPoller.class, args);
    }

    @Scheduled(initialDelay = 10,fixedRate = 1, timeUnit = SECONDS)
    public void timed() {
        log.info("Timer checking.");
        if (working.get())
            return;

        log.info("Shutting down FTP Poller.");
        System.exit(0);
    }

}
