package de.predic8.ticket.ticketgenerator;

import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component("keyFormat")
public class OpentracingKeyFormatStrategy implements JmsKeyFormatStrategy {

    private static final Logger log = LoggerFactory.getLogger(OpentracingKeyFormatStrategy.class);

    private static final String DASH = "__dash__";

    @Override
    public String encodeKey(String key) {
        return key.replaceAll("-", DASH);

    }

    @Override
    public String decodeKey(String key) {
        return key.replaceAll(DASH,"-");
    }
}
