package de.predic8.ticket.ticketgenerator;

import org.apache.camel.builder.*;
import org.apache.camel.dataformat.bindy.csv.*;
import org.springframework.beans.factory.annotation.*;
import org.springframework.stereotype.*;

import static de.predic8.ticket.ticketgenerator.FTPPoller.*;
import static org.apache.camel.builder.endpoint.StaticEndpointBuilders.*;
import static org.apache.camel.model.dataformat.JsonLibrary.*;

@Component
public class PollerRoute extends RouteBuilder {

    @Value("${ftp.server}")
    String ftpServer;

    @Value("${ftp.server.user}")
    String user;

    @Value("${ftp.server.pass}")
    String pass;

    @Override
    public void configure() throws Exception {

        BindyCsvDataFormat csv = new BindyCsvDataFormat(Ticket.class);

        from(sftp(ftpServer)
                .username(user)
                .password(pass)
                .useUserKnownHostsFile(false)
                .delete(true))
                    .id("poller")
                    .process(e -> {working.set(true);})
                    .unmarshal(csv)
                    .log("msg=\"Datei vom FTP-Server abgeholt.\" file=${header.CamelFileName}")
                    .split().body().parallelProcessing()
                        .log("msg=\"Schreibe in ticket.in\" ticket=${body.id}")
                        .marshal().json(Jackson)
                        .to(jms("ticket.in")
                                .advanced().jmsKeyFormatStrategy("keyFormat"))
                    .end()
                    .process(e -> { working.set(false);});
    }
}
