package de.predic8.ticket;

import io.opentracing.Tracer;
import io.opentracing.contrib.jms2.TracingJMSProducer;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSRuntimeException;
import javax.jms.Session;

@ApplicationScoped
public class JMSSender {

    @Inject
    ConnectionFactory connectionFactory;

    @Inject
    Tracer tracer;

    public void sendMessage(String message) {

        System.out.println("tracer = " + tracer);

        

        try (JMSContext context = connectionFactory.createContext(Session.AUTO_ACKNOWLEDGE)) {

            TracingJMSProducer producer = new TracingJMSProducer(context.createProducer(), context, tracer);

            producer.send(context.createQueue("ticket.in"), message);
        } catch (JMSRuntimeException ex) {
            ex.printStackTrace();
        }
    }
}