package de.predic8.ticket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.instrument.*;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import java.lang.invoke.MethodHandles;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON;
import static javax.ws.rs.core.Response.accepted;

@Path("/tickets")
@Produces(APPLICATION_JSON)
@Consumes(APPLICATION_JSON)
public class TicketApi {

    @Inject
    ObjectMapper om;

    @Inject
    JMSSender producer;

    @Inject
    MeterRegistry reg;

    @Inject
    Tracer tracer;

    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @POST
    public Response createTicket(Ticket t) throws JsonProcessingException {
        log.info("createTicket ticket={} type={} date={} comment={}",t.getId(), t.getType(), t.getDate(), t.getComment() );
        reg.counter("ticketcounter").increment();
        tracer.activeSpan().setTag("app","http-endpoint");

        producer.sendMessage(om.writeValueAsString(t));

        return accepted().header("X-Trace", tracer.activeSpan().context().toTraceId()).build();
    }
}