package de.predic8;

import org.apache.camel.builder.*;

import javax.enterprise.context.*;

import static de.predic8.Type.*;
import static de.predic8.Util.*;
import static org.apache.camel.model.dataformat.JsonLibrary.*;

@SuppressWarnings("unused")
@ApplicationScoped
public class TicketRouter extends RouteBuilder {

    static final String LOG = " ticket=${body[id]} type=${body[type]} queue=ticket.in";

    @Override
    public void configure() {

        from(queue("ticket.in"))
                .id("router")
                .unmarshal().json(Jackson)
                .log("msg=\"Verschiebe von ticket.in nach ${body[type].toLowerCase()} Queue\"" + LOG)
                .to("micrometer:counter:routing?tags=type=${body[type]}")
                .setProperty("type", simple("${body[type]}"))
                .marshal().json(Jackson)
                .log("Got:  ${body}")
                .choice()
                    .when(is(BUG))
                        .to(queue("bug"))
                    .when(is(TASK))
                        .to(queue("task"))
                    .when(is(EMERGENCY))
                        .to(queue("emergency"));
    }
}