package de.predic8;

import org.apache.camel.*;
import org.apache.camel.builder.endpoint.dsl.*;

import static org.apache.camel.builder.Builder.simple;
import static org.apache.camel.builder.endpoint.StaticEndpointBuilders.jms;

public class Util {
    public static Predicate is(Type type) {
        return simple("${exchangeProperty.type}").isEqualTo(type);
    }

    public static JmsEndpointBuilderFactory.AdvancedJmsEndpointBuilder queue(String q) {
        return jms(q).advanced().jmsKeyFormatStrategy("keyFormat");
    }
}
