package de.predic8;

import org.apache.camel.builder.*;
import org.apache.camel.component.jackson.*;

import javax.enterprise.context.*;

import static org.apache.camel.builder.endpoint.StaticEndpointBuilders.*;

@SuppressWarnings("unused")
@ApplicationScoped
public class TaskRoute extends RouteBuilder {

    @Override
    public void configure() {

        JacksonDataFormat json = new JacksonDataFormat(Ticket.class);

        from(jms("task").advanced().jmsKeyFormatStrategy("keyFormat"))
                .id("task-route")
                .unmarshal(json)
                .log("msg=\"Ticket aus queue task entnommen.\" ticket=${body.id} type=${body.type}")
                .to(jpa("de.predic8.Ticket"));
    }
}